/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HudOverlayHandler {
    private static HudOverlayHandler instance;
    private final List<ARRenderAction> canvas = new ArrayList<ARRenderAction>();

    public static void init() {
        instance = new HudOverlayHandler();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static HudOverlayHandler getInstance() {
        return instance;
    }

    public static void updateCanvas(List<ARRenderAction> actions) {
        if (instance == null) {
            return;
        }
        HudOverlayHandler.instance.canvas.clear();
        HudOverlayHandler.instance.canvas.addAll(actions);
    }

    public static void clearCanvas() {
        if (instance == null) {
            return;
        }
        HudOverlayHandler.instance.canvas.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getWindow() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack matrixStack = event.getMatrixStack();
        for (ARRenderAction action : this.canvas) {
            action.draw(mc, matrixStack, event.getWindow().m_85443_(), event.getWindow().m_85444_());
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    @SubscribeEvent
    public void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        HudOverlayHandler.clearCanvas();
    }
}

